'''
Created on Nov 4, 2020

@author: Zuhair Hammadi
'''
from odoo import models, api

class ApprovalConfig(models.Model):
    _inherit = 'approval.config'    
    
    @api.model_create_multi
    @api.returns('self', lambda value:value.id)
    def create(self, vals_list):
        records = super(ApprovalConfig, self).create(vals_list)
        
        if any(records.filtered(lambda record : record.model == 'appraisal')):
            self.env['appraisal.states']._update_states()

        return records
    
    
    def write(self, vals):
        res = super(ApprovalConfig, self).write(vals)

        if any(self.filtered(lambda record : record.model == 'appraisal')):
            self.env['appraisal.states']._update_states()
        
        return res
    
    
    def unlink(self):
        is_appraisal = any(self.filtered(lambda record : record.model == 'appraisal'))
        
        res = super(ApprovalConfig, self).unlink()
        if is_appraisal:
            self.env['appraisal.states']._update_states()
        
        return res