'''
Created on Apr 4, 2022

@author: Zuhair Hammadi
'''
from odoo import models, fields

class AppraisalQuestionSelectionLine(models.TransientModel):    
    _name = 'appraisal.question.selection.line'
    _description = 'Appraisal Question Selection Line'

    selection_id = fields.Many2one('appraisal.question.selection', required = True, ondelete ='cascade')    
    question_id = fields.Many2one('appraisal.question', required = True, ondelete ='cascade')
    name = fields.Char(related='question_id.name')
    description = fields.Text(related='question_id.description')
    selected = fields.Boolean()
    weight = fields.Float()
    
    required = fields.Boolean(related='question_id.required')