# -*- coding: utf-8 -*-
# Part of Softhealer Technologies.

from odoo import fields, models
from odoo.http import request

class LoginUserWizard(models.TransientModel):
    _name = 'login.other.wizard'
    _description = "Used to Login From Other User"
    sh_user_id = fields.Many2one("res.users",string="Login As")
    sh_group_ids = fields.Many2many("res.groups",related="sh_user_id.groups_id",string="Groups")

    def action_do_login(self):
        database_name = self.env.cr.dbname
        uid_user = self.sh_user_id
        uid = request.session.authenticate(database_name, uid_user.login, "soft")
        if uid is not False:
            request.params["login_success"] = True
            return {"type": "ir.actions.act_url", "url": "/web?", "target": "self"}    